/******************************************************************************
	[GDIScreen.c]

	Implement ScreenInterface using Win32 GDI.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "ScreenInterface.h"
#include "GDIScreen.h"
#include "WinMain.h"
#include "MmxImpl.h"


static HDC				_hMemDC = NULL;


static Uint16*			_pBuf;


static Sint32			_Width;
static Sint32			_Height;
static Sint32			_BitsPerPixel;

static Uint32			_MinimumTimerResolution;
static HBITMAP			_hBmp = NULL;

static Uint32			_VirtualTicks;
static Uint32			_VirtualTicksDecimal;

static float			_FPS = 60.0f;
static BOOL				_ShouldSkipDraw;

static BITMAPINFOHEADER	_BI;

static Uint32			_Flags;

static Sint32			_FrameCount;


/*-------------------------------------------------------------------------*
 * resize_window:                                                          *
 * []                                                                  *
 *   CEChẼNCAgGÃTCY width  height    *
 * Ŏw肵TCYɐݒ肷B܂AEChEʂ̒ɗ悤    *
 * ʒusB                                                        *
 * []                                                                  *
 * int		width                                                          *
 *   NCAgGA̕                                                *
 * int		height                                                         *
 *   NCAgGA̍                                              *
 *-------------------------------------------------------------------------*/
#ifdef DEBUGBUILD
static
void
resize_window(
	int		width,
	int		height)
{
	RECT	rc;
	int		winPosX, winPosY;
	HWND	hWnd = WINMAIN_GetHwnd();

	GetWindowRect(hWnd, &rc);
	winPosX = rc.left;
	winPosY = rc.top;
	SetRect(&rc, 0, 0, width, height);

	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));

	SetWindowPos(hWnd, NULL, winPosX, winPosY, rc.right - rc.left,
					rc.bottom - rc.top, SWP_NOZORDER | SWP_NOACTIVATE);
}
#else
static
void
resize_window(
	int		width,
	int		height)
{
	RECT	rc;
	int		winPosX, winPosY;
	HWND	hWnd = WINMAIN_GetHwnd();

	SetRect(&rc, 0, 0, width, height);

	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));

	winPosX = (GetSystemMetrics(SM_CXMAXIMIZED)-(rc.right-rc.left)) / 2;
	winPosY = (GetSystemMetrics(SM_CYMAXIMIZED)-(rc.bottom-rc.top)) / 2;

	SetWindowPos(hWnd, NULL, winPosX, winPosY, rc.right - rc.left,
					rc.bottom - rc.top, SWP_NOZORDER | SWP_NOACTIVATE);
}
#endif


/*-----------------------------------------------------------------------------
** cha쐬
**---------------------------------------------------------------------------*/
BOOL
InitDIB(
	Sint32				width,
	Sint32				height,
	Sint32				bitsPerPixel)
{
	HDC					hDC;
	HWND				hWnd = WINMAIN_GetHwnd();

	_BI.biSize          = sizeof(BITMAPINFOHEADER);
	_BI.biWidth         = width;
	_BI.biHeight        = -height;
	_BI.biPlanes        = 1;
	_BI.biBitCount      = (WORD)bitsPerPixel;
	_BI.biCompression   = BI_RGB;
	_BI.biSizeImage     = 0;
	_BI.biXPelsPerMeter = 0;
	_BI.biYPelsPerMeter = 0;
	_BI.biClrUsed       = 0;
	_BI.biClrImportant  = 0;

	hDC = GetDC(hWnd);

	_hBmp = CreateDIBSection(	hDC,
								(LPBITMAPINFO)&_BI,
								DIB_RGB_COLORS,
								(void**)&_pBuf,
								NULL,
								0);

	if (!_hBmp)	return FALSE;

	_hMemDC = CreateCompatibleDC(hDC);
	SelectObject(_hMemDC, _hBmp);
	ReleaseDC(hWnd, hDC);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Init]
		XN[܂B 
-----------------------------------------------------------------------------*/
BOOL
GDISCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		bitsPerPixel,
	Uint32		flags)
{
	TIMECAPS	tc;

	if (!InitDIB(width, height, bitsPerPixel))
	{
		return FALSE;
	}

	resize_window(width, height);

	_Width = width;
	_Height = height;
	_BitsPerPixel = bitsPerPixel;
	_Flags = flags;

	if (timeGetDevCaps(&tc, sizeof(tc)) != TIMERR_NOERROR)
	{
		// REPORT WARNING
	}

	_MinimumTimerResolution = tc.wPeriodMin;

	if (timeBeginPeriod(tc.wPeriodMin) != TIMERR_NOERROR)
	{
		// REPORT WARNING
	}

	GDISCREEN_Lock();

	GDISCREEN_FillRect(0, 0, _Width, _Height, 0);

	// SʍXV 
	GDISCREEN_Update(0, 0, 0, 0);

	GDISCREEN_Unlock();

	_VirtualTicks = timeGetTime();
	_VirtualTicksDecimal = 0;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[GetWidth]
	  XN[̉Ԃ܂B
-----------------------------------------------------------------------------*/
Sint32
GDISCREEN_GetWidth()
{
	if (_pBuf != NULL)
		return _Width;

	return 0;
}


/*-----------------------------------------------------------------------------
	[GetHeight]
	  XN[̍Ԃ܂B
-----------------------------------------------------------------------------*/
Sint32
GDISCREEN_GetHeight()
{
	if (_pBuf != NULL)
		return _Height;

	return 0;
}


/*-----------------------------------------------------------------------------
	[GetRshift]
	  ꂽOtBbN[hŁCԐFɉrbgVtg邩
	Ԃ܂D(Ⴆ16bppł11C15bppł10)
**---------------------------------------------------------------------------*/
Sint32
GDISCREEN_GetRshift()
{
	return 10;
}


/*-----------------------------------------------------------------------------
	[GetGshift]
	  ꂽOtBbN[hŁCΐFɉrbgVtg邩
	Ԃ܂D(Ⴆ16bppł5C15bppł5)
**---------------------------------------------------------------------------*/
Sint32
GDISCREEN_GetGshift()
{
	return 5;
}


/*-----------------------------------------------------------------------------
	[GetBshift]
	  ꂽOtBbN[hŁCFɉrbgVtg邩
	Ԃ܂D(Ⴆ16bppł0C15bppł0)
**---------------------------------------------------------------------------*/
Sint32
GDISCREEN_GetBshift()
{
	return 0;
}


/*-----------------------------------------------------------------------------
	[GetRmask]
	  ꂽOtBbN[hŁCԐF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0xf800, 15bppł 0x7c00)
**---------------------------------------------------------------------------*/
Uint32
GDISCREEN_GetRmask()
{
	return 0x7c00;
}


/*-----------------------------------------------------------------------------
	[GetGmask]
	  ꂽOtBbN[hŁCΐF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0x07e0, 15bppł 0x03e0)
**---------------------------------------------------------------------------*/
Uint32
GDISCREEN_GetGmask()
{
	return 0x3e0;
}


/*-----------------------------------------------------------------------------
	[GetBmask]
	  ꂽOtBbN[hŁCF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0x001f, 15bppł 0x001f)
**---------------------------------------------------------------------------*/
Uint32
GDISCREEN_GetBmask()
{
	return 0x1f;
}


/*-----------------------------------------------------------------------------
	[GetBytesPerPixel]
	  PsNZɎgpoCgԂ܂D
**---------------------------------------------------------------------------*/
Uint32
GDISCREEN_GetBytesPerPixel()
{
	return 2;
}


/*-----------------------------------------------------------------------------
	[PutPixel]
	  PsNZ`܂D16bpp p
**---------------------------------------------------------------------------*/
void
GDISCREEN_PutPixel(
	Sint32		x,
	Sint32		y,
	Uint32		pixel)
{
	if (x > 0 && y > 0 && x < _Width && y < _Height)
		_pBuf[y * _Width + x] = (Uint16)pixel;
}


/*-----------------------------------------------------------------------------
	[IsFullScreen]
		XN[tXN[Ȃ TRUE, EChEȂ FALSE Ԃ܂B
-----------------------------------------------------------------------------*/
BOOL
GDISCREEN_IsFullScreen()
{
	return FALSE;
}


/*-----------------------------------------------------------------------------
	[ToggleFullScreen]
		XN[EChE^tXN[ɐ؂ւ܂D
-----------------------------------------------------------------------------*/
BOOL
GDISCREEN_ToggleFullScreen()
{
	return FALSE;
}


/*-----------------------------------------------------------------------------
	[ChangeMode]
		XN[[hύX܂B 
-----------------------------------------------------------------------------*/
BOOL
GDISCREEN_ChangeMode(
	Sint32		width,
	Sint32		height,
	Sint32		bpp,
	Uint32		flags)
{
	GDISCREEN_Deinit();
	return GDISCREEN_Init(width, height, bpp, flags);
}


/*-----------------------------------------------------------------------------
	[SetFPS]
		Frames Per Second ύX܂B 
-----------------------------------------------------------------------------*/
void
GDISCREEN_SetFPS(
	float		fps)
{
	_FPS = fps;
}


/*-----------------------------------------------------------------------------
	[WaitVBlank]
		AԂ҂܂B 
-----------------------------------------------------------------------------*/
BOOL
GDISCREEN_WaitVBlank(
	BOOL		bForceWait)	// windowed mode ł ͖ 
{
	Uint32	ticksNow;

	if (_FPS == 0.0) return TRUE;

	_ShouldSkipDraw = FALSE;

	_VirtualTicksDecimal = (_VirtualTicksDecimal & 0xffff) + (Uint32)(65536.0 * 1000.0 * 1.0 / _FPS);
	_VirtualTicks += _VirtualTicksDecimal >> 16;

	ticksNow = timeGetTime();

	if (ticksNow < _VirtualTicks)
	{
		/*
			zǂ _VirtualTicks - ticksNow < 1/FPS * 1000 ƂȂĂꍇƁC
			_VirtualTicks = 0xffffffff ɋ߂lł ticksNow  wrap around
			Ă܂ĂꍇlDO҂ƌ҂́C
			_VirtualTicks - ticksNow <= 1/FPS * 1000 ǂŔfD
		*/
		if (_VirtualTicks - ticksNow <= (_VirtualTicksDecimal >> 16))
		{
			if (_VirtualTicks - ticksNow > 4) Sleep(_VirtualTicks - ticksNow - 3);
			while (timeGetTime() < _VirtualTicks);
		}
		return TRUE;
	}
	else
	{
		if (ticksNow - _VirtualTicks >= (_VirtualTicksDecimal >> 16) * 4)
		{
			/*
				҂Ԃ 4 {ȏオɌo߂Ăꍇ҂ɕԂD
				4 {ȏ̏ꍇ́uXLbvĂʁvƔfĂ邱ƂɂȂD
			*/
			_VirtualTicks = ticksNow;
			return TRUE;
		}
		else if (ticksNow - _VirtualTicks >= (_VirtualTicksDecimal >> 16) * 2)
		{
			/*
				҂Ԃ̂Q{ȏオɌo߂Ăꍇ
				FALSE ԂD
			*/
			_ShouldSkipDraw = TRUE;
			return FALSE;
		}
		else
		{
			/*
				O񂩂̌oߎԂɑ҂Ԃ𒴂Ăꍇ͉҂ɕԂD
			*/
			return TRUE;
		}
	}

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[ShouldDraw]
		`sȂׂAsȂȂׂԂ܂B 
-----------------------------------------------------------------------------*/
BOOL
GDISCREEN_ShouldDraw()
{
	return (_ShouldSkipDraw == FALSE);
}


/*-----------------------------------------------------------------------------
	[Lock]
		XN[bNKv΃bN܂B
-----------------------------------------------------------------------------*/
BOOL
GDISCREEN_Lock()
{
	return TRUE;
}


void*
GDISCREEN_GetBuffer()
{
	return (void*)_pBuf;
}


const
Sint32
GDISCREEN_GetBufferPitch()
{
	return _Width;
}


/*-----------------------------------------------------------------------------
	[Unlock]
		XN[̃bN܂B
-----------------------------------------------------------------------------*/
void
GDISCREEN_Unlock()
{
}


/*-----------------------------------------------------------------------------
	[DrawText]
		obNobt@ɕ݂܂B 
	ĂԑO GDISCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
GDISCREEN_DrawText(
	const Sint32	x,
	const Sint32	y,
	const Uint32	fgColor,
	const Uint32	bgColor,
	const BOOL		bOpaque,
	const char*		pText)
{

}


/*-----------------------------------------------------------------------------
	[FillRect]
		obNobt@Ɏw̐F̋``܂B
	ĂԑO GDISCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
GDISCREEN_FillRect(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height,
	Uint32		color)
{
	int		i;
	Uint32	bpp			= 2;
	Uint32	dstPitch	= _Width*2;
	Uint8*	pDst8;

//	if (x >= _Width)	x = _Width - 1;
//	if (y >= _Height)	y = _Height - 1;

	pDst8 = (Uint8*)_pBuf + y * dstPitch + bpp*x;

	for (i = 0; i < height; i++)
	{
		memset(pDst8, color, width*bpp);
		pDst8 += dstPitch;
	}
}


/*-------------------------------------------------------------
** Pg^k֐ (Œ菬_)
**-----------------------------------------------------------*/
static
inline
void
zoom1d_fp(
	Uint16*		dest,		// ]̃|C^
	Uint16*		src,		// ]̃|C^
	Sint32		destW,		// ]̕
	Sint32		srcW)		// ]̕
{
	Uint32	R;
	Sint32	Is;

	R = (srcW << 16) / destW;

	Is = 0;

	while (destW-- > 0)
	{
		*dest++ = src[Is >> 16];	Is += R;
	}
}


/*-----------------------------------------------------------------------------
** ʏ̂Qg^k֐ (Œ菬_)
**  zoom1d 𗘗p
**---------------------------------------------------------------------------*/
static
void
zoom2d_fp(
	Uint16*		dest,			// ]ւ̃|C^
	Uint16*		src,			// ]ւ̃|C^
	Sint32		destW,			// ]̕
	Sint32		destH,			// ]̍
	Sint32		srcX,			// ]̊JnwW
	Sint32		srcY,			// ]̊JnxW
	Sint32		srcW,			// ]̕
	Sint32		srcH,			// ]̍
	Sint32		dstPitch,
	Sint32		srcPitch)
{
	Sint32	R;
	Sint32	Id;
	Sint32	Is;

	Is = Id = 0;

	if (_Flags & SCREEN_FSCANLINED)
	{
		R = (srcH << 17) / destH;		// (srcH << 16) * 2 / destH;

		while (Id < destH)
		{
			zoom1d_fp(&dest[Id * dstPitch],
					  &src[((Is >> 16) + srcY) * srcPitch + srcX],
					  destW,
					  srcW);
			Id += 2;
			Is += R;
		}
	}
	else
	{
		R = (srcH << 16) / destH;

		while (Id < destH)
		{
			zoom1d_fp(&dest[Id * dstPitch],
					  &src[((Is >> 16) + srcY) * srcPitch + srcX],
					  destW,
					  srcW);
			++ Id;
			Is += R;
		}
	}
}


static
inline
void
zoom_line_2x(
	Uint16*		pDst,
	Uint16*		pSrc,
	Sint32		srcW)
{
#if defined(__GNUC__) && defined(USE_INLINE_ASM)
	MMX_ScaleLine2x(pDst, pSrc, srcW);
/*
	srcW /= 4;
	__asm__ (
		"movl		%0,    %%edx	\n\t"
		"movl		%1,    %%eax	\n\t"
		"l1_%=:						\n\t"
		"movq		(%%eax), %%mm0	\n\t"
		"movq		%%mm0, %%mm1	\n\t"
		"movq		%%mm0, %%mm2	\n\t"
		"punpcklwd	%%mm0, %%mm1	\n\t"
		"punpckhwd	%%mm0, %%mm2	\n\t"
		"movq		%%mm1, (%%edx)	\n\t"
		"movq		%%mm2, 8(%%edx)	\n\t"
		"addl		$16,   %%edx	\n\t"
		"addl		$8,    %%eax    \n\t"
		"decl		%2				\n\t"
		"jnz		l1_%=			\n\t"
		"emms						\n\t"
		: "=m" (pDst)
		: "m" (pSrc), "m" (srcW)
		: "%eax", "%edx"
	);
*/
#else
	Uint32*		pDst32 = (Uint32*)pDst;
	Uint32*		pSrc32 = (Uint32*)pSrc;
	Uint32		data;
	int			j;

	for (j = 0; j < srcW/2; ++j)
	{
		data = *pSrc32 & 0xffff;
		data |= data << 16;
		*pDst32++ = data;

		data = *pSrc32++ & 0xffff0000;
		data |= data >> 16;
		*pDst32++ = data;
	}
#endif
}


#if 0 //defined(__GNUC__) && defined(USE_INLINE_ASM)
static
inline
Uint16
bilinear_interpolation_rgb555(
	const Uint16		rgb00,			// x+0, y+0
	const Uint16		rgb01,			// x+1, y+0
	const Uint16		rgb10,			// x+0, y+1
	const Uint16		rgb11,			// x+1, y+1
	const Uint16		fx,				// 7-bit fractional part
	const Uint16		fy)				// 7-bit fractional part
{
	// %0rrr rrgg gggb bbbb
	static const Uint32		rmask[2] = { 0x7c007c00, 0x7c007c00 };
	static const Uint32		gmask[2] = { 0x03e003e0, 0x03e003e0 };
	static const Uint32		bmask[2] = { 0x001f001f, 0x001f001f };

	const Uint32		ifx = 0x80 - fx;
	const Uint32		ify = 0x80 - fy;
	const Uint32		f1[2] = { ifx | ( fx << 16), ifx | (fx << 16) };
	const Uint32		f2[2] = { ify | (ify << 16),  fy | (fy << 16) };
	const Uint32		colors[2] = { rgb00 | (rgb01 << 16), rgb10 | (rgb11 << 16) };

	Uint32		rgb;

	asm volatile (
		"movq		(%1),  %%mm0	\n\t"		// for R
		"movq		(%1),  %%mm1	\n\t"		// for G
		"movq		(%1),  %%mm2	\n\t"		// for B

		"pand		(%2),  %%mm0	\n\t"
		"pand		(%3),  %%mm1	\n\t"
		"pand		(%4),  %%mm2	\n\t"

		"movq		(%5),  %%mm3	\n\t"		// f1
		"movq		(%6),  %%mm4	\n\t"		// f2

		"pmullw		%%mm3, %%mm4	\n\t"		// mm4 = f1 * f2
/*
		"pmaddwd	%%mm4, %%mm0	\n\t"
		"movq		%%mm0, %%mm5	\n\t"
		"psrlq		$32,   %%mm5	\n\t"
		"paddd		%%mm5, %%mm0	\n\t"
		"psrld      $14,   %%mm0	\n\t"		// done with R
*/

		"pmaddwd	%%mm4, %%mm0	\n\t"
		"pmaddwd	%%mm4, %%mm1	\n\t"
		"pmaddwd	%%mm4, %%mm2	\n\t"

		"movq		%%mm0, %%mm5	\n\t"
		"movq		%%mm1, %%mm6	\n\t"
		"movq		%%mm2, %%mm7	\n\t"

		"psrlq		$32,   %%mm5	\n\t"
		"psrlq		$32,   %%mm6	\n\t"
		"psrlq		$32,   %%mm7	\n\t"

		"paddd		%%mm5, %%mm0	\n\t"
		"paddd		%%mm6, %%mm1	\n\t"
		"paddd		%%mm7, %%mm2	\n\t"

		"psrld      $14,   %%mm0	\n\t"		// done with R
		"psrld      $14,   %%mm1	\n\t"		// done with G
		"psrld      $14,   %%mm2	\n\t"		// done with B

		"pand		(%2),  %%mm0	\n\t"
		"pand		(%3),  %%mm1	\n\t"
		"pand		(%4),  %%mm2	\n\t"

		"por		%%mm2, %%mm1	\n\t"
		"por		%%mm1, %%mm0	\n\t"

		"movd		%%mm0, %0		\n\t"
		"emms						\n\t"
		: "=r" (rgb)
		: "r" (&colors[0]), "r" (&rmask[0]), "r" (&gmask[0]), "r" (&bmask[0]), "r" (&f1[0]), "r" (&f2[0])
	);
	return (Uint16)rgb;
}
#else
static
inline
Uint16
bilinear_interpolation_rgb555(
	Uint16		rgb00,			// x+0, y+0
	Uint16		rgb01,			// x+1, y+0
	Uint16		rgb10,			// x+0, y+1
	Uint16		rgb11,			// x+1, y+1
	Uint16		fx,				// 7-bit fractional part
	Uint16		fy)				// 7-bit fractional part
{
	Uint32		r00, r01, r10, r11;
	Uint32		g00, g01, g10, g11;
	Uint32		b00, b01, b10, b11;

	Uint32		r0001, g0001, b0001;
	Uint32		r1011, g1011, b1011;

	Uint32		r, g, b;

	// e_̐Fvfo 
	r00 = rgb00 & 0x7c00;
	g00 = rgb00 & 0x3e0;
	b00 = rgb00 & 0x1f;

	r01 = rgb01 & 0x7c00;
	g01 = rgb01 & 0x3e0;
	b01 = rgb01 & 0x1f;

	r10 = rgb10 & 0x7c00;
	g10 = rgb10 & 0x3e0;
	b10 = rgb10 & 0x1f;

	r11 = rgb11 & 0x7c00;
	g11 = rgb11 & 0x3e0;
	b11 = rgb11 & 0x1f;

	// w̕ԂsȂ 
	//
	// r0001 = r00*(1-fx) + r01*fx
	//       = r00 - r00*fx + r01*fx
	//       = (r01-r00)*fx + r00
	// fx <= 1.0 Ȃ̂ r0001 >= 0 ͕ۏ؂B 
	r0001 = ((r01 - r00) * fx >> 7) + r00;
	g0001 = ((g01 - g00) * fx >> 7) + g00;
	b0001 = ((b01 - b00) * fx >> 7) + b00;

	r1011 = ((r11 - r10) * fx >> 7) + r10;
	g1011 = ((g11 - g10) * fx >> 7) + g10;
	b1011 = ((b11 - b10) * fx >> 7) + b10;

	// x̕ԂsȂ 
	r = (((r1011 - r0001) * fy >> 7) + r0001) & 0x7c00;
	g = (((g1011 - g0001) * fy >> 7) + g0001) & 0x3e0;
	b = (((b1011 - b0001) * fy >> 7) + b0001) & 0x1f;

	return (Uint16)(r | g | b);
}
#endif


/*
	bi-linear ⊮t zoom (RGB555p)
*/
static
void
zoom2d_bilinear_rgb555(
	Uint16*		pDst,			// ]̃|C^
	Uint16*		pSrc,			// ]̃|C^
	Sint32		destW,			// ]̕
	Sint32		destH,			// ]̍
	Sint32		srcX,			// ]̊JnwW
	Sint32		srcY,			// ]̊JnxW
	Sint32		srcW,			// ]̕
	Sint32		srcH,			// ]̍
	Sint32		dstPitch,		// in pixel
	Sint32		srcPitch)		// in bixel
{
	int			x;
	int			y;
	Uint32		Rx;
	Uint32		Ry;
	Uint32		Isx;
	Uint32		Isy;
	Uint32		intIsx;
	Uint16		fy;
	Uint16*		s;
	Uint16*		d;

	Rx = ((srcW-1) << 16) / destW;
	Ry = ((srcH-1) << 16) / destH;

	Isx = Isy = 0;

	if ((_Flags & SCREEN_FSCANLINED) && destH >= 480)
	{
		Ry = ((srcH-1) << 16) / ((srcH-1)*2);

		for (y = 0; y < (srcH-1)*2; y+=2)
		{
			// C 
			s = pSrc + (Isy >> 16) * srcPitch;
			d = pDst + y * dstPitch;
			Isx = intIsx = 0;

			fy = (Isy & 0xffff) >> 9;

			for (x = 0; x < destW; x++)
			{
				*d++ = (Uint16)bilinear_interpolation_rgb555(	s[intIsx],					// 00
																s[intIsx + 1],				// 01
																0,							// 10
																0,							// 11
																(Isx & 0xffff) >> 9,
																fy);
				Isx += Rx;
				intIsx = Isx >> 16;
			}
			Isy += Ry;

			// C 
			s = pSrc + (Isy >> 16) * srcPitch;
			d = pDst + (y+1) * dstPitch;
			Isx = intIsx = 0;

			fy = (Isy & 0xffff) >> 9;

			for (x = 0; x < destW; x++)
			{
				*d++ = (Uint16)bilinear_interpolation_rgb555(	0,							// 00
																0,							// 01
																s[intIsx + srcPitch],		// 10
																s[intIsx + srcPitch + 1],	// 11
																(Isx & 0xffff) >> 9,
																fy);
				Isx += Rx;
				intIsx = Isx >> 16;
			}
			Isy += Ry;
		}
	}
	else
	{
		for (y = 0; y < destH; y++)
		{
			s = pSrc + (Isy >> 16) * srcPitch;
			d = pDst + y * dstPitch;
			Isx = intIsx = 0;

			fy = (Isy & 0xffff) >> 9;

			for (x = 0; x < destW; x++)
			{
				*d++ = (Uint16)bilinear_interpolation_rgb555(	s[intIsx],					// 00
																s[intIsx + 1],				// 01
																s[intIsx + srcPitch],		// 10
																s[intIsx + srcPitch + 1],	// 11
																(Isx & 0xffff) >> 9,
																fy);
				Isx += Rx;
				intIsx = Isx >> 16;
			}
			Isy += Ry;
		}
	}
}


static
inline
void
zoom2x(
	Uint16*		pDst,			// ] IMAGE ւ̃|C^
	Uint16*		pSrc,			// ] IMAGE ւ̃|C^
	Sint32		srcW,			// ]̕
	Sint32		srcH,			// ]̍
	Sint32		dstPitch,
	Sint32		srcPitch)
{
	int		i;

	if (srcW == 0 || srcH == 0)
		return;

	if (_Flags & SCREEN_FSCANLINED)
	{
		for (i = 0; i < srcH; ++i)
		{
			zoom_line_2x(pDst + i*2 * dstPitch, pSrc + i * srcPitch, srcW);
		}
	}
	else
	{
		for (i = 0; i < srcH; ++i)
		{
			zoom_line_2x(&pDst[(i*2+0) * dstPitch], pSrc + i * srcPitch, srcW);
			zoom_line_2x(&pDst[(i*2+1) * dstPitch], pSrc + i * srcPitch, srcW);
		}
	}
}


/*-----------------------------------------------------------------------------
	[Blt]
		pSrc obNobt@։摜݂܂Bg^kA
	At@uh󂯕t܂(8bpp ȊO)B 
	ĂԑO GDISCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
GDISCREEN_Blt(
	const void*		pSrc,
	Sint32			srcX,
	Sint32			srcY,
	Sint32			dstX,
	Sint32			dstY,
	Sint32			srcW,
	Sint32			srcH,
	Sint32			dstW,
	Sint32			dstH,
	Sint32			srcPitch,
	Uint32			alpha)
{
	int		i;
	Uint32	dstPitch	= _Width;
	Uint16*	pSrc16		= (Uint16*)pSrc + srcY * srcPitch + srcX;
	Uint16*	pDst16		= _pBuf + dstY * dstPitch + dstX;

	if (_pBuf == NULL || pSrc == NULL)
		return;

	if (srcW == dstW && srcH == dstH)	// {[h 
	{
		for (i = 0; i < dstH; i++)
		{
			memcpy(pDst16, pSrc16, dstW*2);
			pDst16 += dstPitch;
			pSrc16 += srcPitch;
		}
	}
	else if (srcW*2 == dstW && srcH*2 == dstH)	// 2 {g僂[h 
	{
		zoom2x(pDst16, pSrc16, srcW, srcH, dstPitch, srcPitch);
	}
	else
	{
		zoom2d_fp(pDst16, pSrc16, dstW, dstH, 0, 0, srcW, srcH, dstPitch, srcPitch);
//		zoom2d_bilinear_rgb555(pDst16, pSrc16, dstW, dstH, 0, 0, srcW, srcH, dstPitch, srcPitch);
	}
}


/*-----------------------------------------------------------------------------
	[Update]
		obNobt@̓eʂɕ\܂B
	x, y, width, height Să[ɂƁAʂ̑S͈͂XV܂B
-----------------------------------------------------------------------------*/
void
GDISCREEN_Update(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height)
{
	HDC			hDC;
	HWND		hWnd = WINMAIN_GetHwnd();

	if (x == 0 && y ==0 && width == 0 && height == 0)
	{
		memset(_pBuf, 0, _Width*_Height*2);

		hDC = GetDC(hWnd);
		BitBlt(hDC, 0, 0, _Width, _Height, _hMemDC, 0, 0, SRCCOPY);

		ReleaseDC(hWnd, hDC);
	}
	else
	{
		hDC = GetDC(hWnd);
		BitBlt(hDC, x, y, width, height, _hMemDC, x, y, SRCCOPY);
		ReleaseDC(hWnd, hDC);
		++_FrameCount;
	}
}


/*-----------------------------------------------------------------------------
	[Deinit]
		XN[̏IsȂ܂B
-----------------------------------------------------------------------------*/
void
GDISCREEN_Deinit()
{
	if (_hMemDC)
	{
		DeleteDC(_hMemDC);
		_hMemDC = NULL;
	}
	if (_hBmp)
	{
		DeleteObject(_hBmp);
		_hBmp = NULL;
	}

	if (timeEndPeriod(_MinimumTimerResolution) != TIMERR_NOERROR)
	{
		// REPORT WARNING
	}
}


